
MEMORY {

//  512K Internal SRAM Assigned to Z6

    sram    	 : ORIGIN = 0x40000000, LENGTH = 512k

//  2M Internal Flash - 1.5M Assigned to Z6

    flash_rcw	: ORIGIN = 0x00000000, LENGTH = 0x8
    int_flash	: ORIGIN = ., LENGTH = 0x17FFFF - 0x8
}

DEFAULTS {

    heap_reserve = 1K
    stack_reserve = 1K

}

//
// Program layout for running out of RAM.
//


SECTIONS
{
    .PPC.EMB.sdata0 	            	    	    ABS : > sram
    .PPC.EMB.sbss0                            CLEAR ABS : > .

    .init       					: { *(.init) } > .
    .text  			            		: > .
    .vletext 				    		: > .
    .syscall 				    		: > .
    .secinfo 				    		: > .
    .rodata 				    		: > .
    .sdata2 				    		: > .
    .fixaddr			 	   		: > .
    .fixtype						: > .

    .sdabase 		        	      ALIGN(16) : > sram	
    .sdata 						: > .
    .sbss 						: > .
    .data 						: > .
    .bss 		  				: > .
    .heap                  ALIGN(16) PAD(heap_reserve)  : > .   
    .stack                 ALIGN(16) PAD(stack_reserve) : > .
	
    .isrvectbl    ALIGN(0x800)   : {} > .   /* ISR Vector Table - must be 2K aligned */
    .xptn_vectors ALIGN(0x10000) : {} > .   /* Exception Vector Table (IVPR) - align 64K boundary */
    .IVOR4_HWvectors ALIGN(0x800): {} > .   /* IVOR4 HW Vector Table (IVPR) - align 2K boundary */

/* Interrupt Handler Parameters */
__IVPR = ADDR(.xptn_vectors);

//
// These special symbols mark the bounds of RAM and ROM memory.
// They are used by the MULTI debugger.
//
    __ghs_ramstart  = MEMADDR(sram);
    __ghs_ramend    = MEMENDADDR(sram);
    __ghs_romstart  = MEMADDR(int_flash);
    __ghs_romend    = MEMENDADDR(int_flash);
    
}
